#pragma once

#include "gmplugin.h"

struct EndGameRecs_t
{
	StringClass MapName;
	StringClass BestKDName;
	StringClass MostKillsName;
	StringClass MVPName;
	float MVPScore;
	float BestKDAmount;
	float MostKillsAmount;
};

class Functions
{
public:
	static bool Functions::EndGameThreadExists;

	static void Show_Fatal_Warning(const char* Error); // Shows a Window message box
	static void Debug_Log(const char *Text); // Logs to console, todo make configurabl-y log to text file
	static void Page(int ID, const char *Format, ...); // PPAGE or show coloured message with sound if possible
	static void Console(const char *Format, ...); // Formated Console_Input()
	static void Create_Thread(LPTHREAD_START_ROUTINE Function, LPVOID Params);
	static DWORD WINAPI Get_Host_Name(LPVOID params);
	static DWORD WINAPI Enforce_Auth_Protect(LPVOID params);
	static DWORD WINAPI Auto_Announce(LPVOID params); // Thread that randomly announces a host message
	static int Get_Part_Names_Fixed(const char *name1); // Returns the amount of players with the partial name
	static GameObject* Get_Part_Name_Fixed(const char *name1); // Returns the fullname of the partial name or NULL if the input is invalid
	static void Announce_Auth(Player_t* Data); // Shows a host MSG for when a player authenticates
	static void Host_Msg(StringClass Text); // Prepends the name of the bot to the host message
	static void Host_Msg(const char* Format, ...); // Likewise
	static void Format_Time(time_t t, const char *Format, char *buffer, int Length); // Formats the buffer with strftime()
	static const char* Get_Translated_Name(GameObject* obj); // Translates the preset name, wrapper for future code
	static const char* Get_Translated_Name(const char *Preset); // Translates the preset definition name, wrapper for future code
	static void Disarm_Player(int ID); // Disarms beacons and C4
	static void Check_Player(int ID); // Does database stuff for a player, should probably change the name of this function
	static bool Host_Hook(int ID, TextMessageEnum Type, const char *Msg); // Logs host messages to IRC
	static bool Is_Number(const char *String); // Calls isdigit() on a whole string
	static void Send_End_Map_Info(int WinType); // Sends end map text to IRC
	static void Purchase_Mon_Hook(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset, unsigned int purchaseret, const char *data);
	static int Purchase_Hook(BaseControllerClass *base,GameObject *purchaser,unsigned int cost,unsigned int preset,const char *data);
	static int Get_Status(const char* Nick); // Gets the IRC oper status for a nick

	static int Get_Highest_Score(); // Returns the player ID of the guy with the highest score in-game
	static int Get_Most_Kills();
	static int Get_Best_KD();

	static DWORD WINAPI Show_End_Game_Recs(LPVOID params); // Shows the recs for mvp/kills and KD at the start of a level like BRenBot
};